package net.lecnam.info.channel;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;

public record LocalObjectWriter<B>(BlockingQueue<B> bq) implements ObjectWriter<B> {

	@Override
	public void writeObject(B arg) throws IOException {
		try {
			bq.put(arg);
		} catch (InterruptedException e) {
			throw new IOException(e);
		}
	}

}
