package net.lecnam.info.channel;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;

public record LocalObjectReader<A>(BlockingQueue<A> bq) implements ObjectReader<A> {

	@Override
	public A readObject() throws IOException {
		try {
			return bq.take();
		} catch (InterruptedException e) {
			throw new IOException(e);
		}
	}

}
