package net.lecnam.info;

import java.io.IOException;
import java.util.logging.Logger;

import net.lecnam.info.channel.ObjectReader;
import net.lecnam.info.channel.ObjectWriter;

public class Server<T> implements Runnable {

	ObjectReader<Task<T>> in;
	ObjectWriter<T> out;
	ComputeEngine<T> engine;
	
	Logger logger = Logger.getLogger("Server");

	Server(ObjectReader<Task<T>> in, ObjectWriter<T> out) {
		this.in = in;
		this.out = out;
		this.engine = new ComputeEngine<T>();
	}
	
	@Override
	public void run() {
		try {
			while (true) {
				var task = in.readObject();
				System.out.println("Task: " + task);
				var result = engine.executeTask(task);
				System.out.println("Result: " + result);
				out.writeObject(result);
			}
		} catch (IOException e) {
			throw new Error(e);
		}

	}

}
