package net.lecnam.info;

import java.io.IOException;

import net.lecnam.info.channel.ObjectReader;
import net.lecnam.info.channel.ObjectWriter;

public class RemoteComputeEngine<T> {

	ObjectReader<T> in;
	ObjectWriter<Task<T>> out;
	
	RemoteComputeEngine(ObjectReader<T> in, ObjectWriter<Task<T>> out) {
		this.in = in;
		this.out = out;
	}

	T executeTask(Task<T> t) throws IOException {
		out.writeObject(t);
		var result = in.readObject();
		return result;
	}
	
}
