package net.lecnam.info;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

import net.lecnam.info.channel.LocalObjectReader;
import net.lecnam.info.channel.LocalObjectWriter;
import net.lecnam.info.channel.ObjectReader;
import net.lecnam.info.channel.ObjectWriter;

public class Main {

	public static void main(String[] args) throws IOException {

	    BlockingQueue<Task<Integer>> bqcs = new LinkedBlockingQueue<>();
	    BlockingQueue<Integer> bqsc = new LinkedBlockingQueue<>();

		ObjectWriter<Integer> ows = new LocalObjectWriter<>(bqsc);
		ObjectReader<Task<Integer>> ors = new LocalObjectReader<>(bqcs);

		Server<Integer> server = new Server<>(ors, ows);

		ObjectWriter<Task<Integer>> owc = new LocalObjectWriter<>(bqcs);
		ObjectReader<Integer> orc = new LocalObjectReader<>(bqsc);

		Client client = new Client(orc, owc);

	    Thread tc = new Thread(client);
	    Thread ts = new Thread(server);

	    tc.start();
	    ts.start();

	}

}
