package net.lecnam.info;

import java.io.IOException;

import net.lecnam.info.channel.ObjectReader;
import net.lecnam.info.channel.ObjectWriter;

public class Client implements Runnable {

	ObjectReader<Integer> in;
	ObjectWriter<Task<Integer>> out;
	RemoteComputeEngine<Integer> api;

	Client(ObjectReader<Integer> in, ObjectWriter<Task<Integer>> out) {
		this.in = in;
		this.out = out;
		this.api = new RemoteComputeEngine<Integer>(in, out);
	}

	@Override
	public void run() {
		try {
			var task = new SimpleTask(4, 7);
			var result = api.executeTask(task);
			System.out.println(result);
			var task2 = new SimpleTask(47, 79);
			var result2 = api.executeTask(task2);
			System.out.println(result2);
		} catch (IOException e) {
			throw new Error(e);
		}
	}

}
