package net.lecnam.info;

import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;

public class ServerMain {

	public static void main(String[] args) throws Exception {
		ServerSocket ss = new ServerSocket(54321);
		Socket s = ss.accept();
		OutputStream os = s.getOutputStream();
		InputStream is = s.getInputStream();
		ObjectOutput oo = new ObjectOutputStream(os);
		ObjectInput oi = new ObjectInputStream(is);
	
		ObjectWriter<Answer<Integer>> ow = new RemoteObjectWriter<>(oo);
		ObjectReader<Request<String, Integer>> or = new RemoteObjectReader<>(oi);
		
		var immutableMap = Map.of("A", 10, "B", 20, "C", 30, "D", 40);
		var map = new HashMap<>(immutableMap);
		
		Server<String, Integer> server = new Server<>(or, ow, map);
		server.run();
		s.close();
		ss.close();
	}

}
