package net.lecnam.info;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;

public class Server<K, V> implements Runnable {

	ObjectReader<Request<K,V>> in;
	ObjectWriter<Answer<V>> out;
	Map<K,V> map;

	Logger logger = Logger.getLogger("Server");

	Server(ObjectReader<Request<K,V>> in, ObjectWriter<Answer<V>> out, Map<K,V> map) {
		this.in = in;
		this.out = out;
		this.map = map;
	}

	@Override
	public void run() {
		logger.info("Server is running...");
		try {
			Request<K,V> request = null;
			boolean done = false;
			while (!done) {
				request = in.readObject();
				logger.info("Request: " + request);					
				switch (request) {
					case Put<K, V>(K key, V value) -> {
						var oldValue = map.put(key, value);
						var answer = new OldValue<>(oldValue);
						logger.info("Answer: " + answer);				
						out.writeObject(answer);
					}
					case Get<K, V>(K key) -> {
						var value = map.get(key);
						var answer = new Value<>(value);
						logger.info("Answer: " + answer);				
						out.writeObject(answer);
					}
					case Stop<K, V>() -> {
						done = true;
					}
				}
			}
		} catch (IOException e) {
			throw new Error(e);
		}
	}

}
