package net.lecnam.info;

import java.io.IOException;

public class RemoteMap<K, V> {

	ObjectReader<Answer<V>> in;
	ObjectWriter<Request<K,V>> out;

	public RemoteMap(ObjectReader<Answer<V>> in, ObjectWriter<Request<K,V>> out) {
		this.in = in;
		this.out = out;
	}

	public V put(K key, V value) throws IOException {
		out.writeObject(new Put<>(key, value));
		Answer<V> answer = in.readObject();
		switch (answer) {
			case OldValue<V>(V oldValue) -> {
				return oldValue;
			}
			default -> {
				throw new Error("OldValue expected");
			}
		}
	}

	public V get(K key) throws IOException {
		out.writeObject(new Get<>(key));
		Answer<V> answer = in.readObject();
		switch (answer) {
			case Value<V>(V value) -> {
				return value;
			}
			default -> {
				throw new Error("Value expected");
			}
		}
	}

	void close() throws IOException {
		out.writeObject(new Stop<>());
	}

}
