package net.lecnam.info;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class Main {

	public static void main(String[] args) throws IOException {
		
	    BlockingQueue<Answer<Integer>> bqcs = new LinkedBlockingQueue<>();
	    BlockingQueue<Request<String, Integer>> bqsc = new LinkedBlockingQueue<>();

		ObjectWriter<Answer<Integer>> ows = new LocalObjectWriter<>(bqcs);
		ObjectReader<Request<String, Integer>> ors = new LocalObjectReader<>(bqsc);
		
		var immutableMap = Map.of("A", 10, "B", 20, "C", 30, "D", 40);
		var map = new HashMap<>(immutableMap);
		
		Server<String, Integer> server = new Server<>(ors, ows, map);
	    
		ObjectWriter<Request<String, Integer>> owc = new LocalObjectWriter<>(bqsc);
		ObjectReader<Answer<Integer>> orc = new LocalObjectReader<>(bqcs);
		
		Client client = new Client(orc, owc);

	    Thread tc = new Thread(client);
	    Thread ts = new Thread(server);

	    tc.start();
	    ts.start();

	}

}
