package net.lecnam.info.util;

import java.util.Map.Entry;
import java.util.function.BiFunction;

public record Pair<A, B>(A fst, B snd) implements Entry<A,B> {

	public static <A, B> Pair<A, B> pair(A fst, B snd) {
		return new Pair<A, B>(fst, snd);
	}

	public <R> R match(BiFunction<A, B, R> f) {
		return f.apply(fst, snd);
	}

	@Override
	public A getKey() {
		return fst;
	}

	@Override
	public B getValue() {
		return snd;
	}

	@Override
	public B setValue(B value) {
		throw new UnsupportedOperationException();
	}
	
}
