package net.lecnam.info.util;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class Functions {

	public static <T> void apply(Consumer<T> c, T t) {
		c.accept(t);
	}

	public static <T> Boolean apply(Predicate<T> p, T t) {
		return p.test(t);
	}

	public static <R> R apply(Supplier<R> s) {
		return s.get();
	}

	public static <T, R> R apply(Function<T, R> f, T t) {
		return f.apply(t);
	}

	public static <T, U, R> R apply(BiFunction<T, U, R> f, T t, U u) {
		return f.apply(t, u);
	}
}
