package net.lecnam.info.ex4;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class Server implements Runnable {

	RequestReader in;
	AnswerWriter out;
	List<String> l = Arrays.asList("A", "B", "C", "7", "9", "11", "13", "17");

	Logger logger = Logger.getLogger("Server");

	Server(RequestReader in, AnswerWriter out) {
		this.in = in;
		this.out = out;
	}

	@Override
	public void run() {
		logger.info("Server is running...");
		try {
			Request request = null;
			boolean done = false;
			while (!done) {
				request = in.readData();
				switch (request) {
					case GetSize() -> {
						out.writeData(new Size(l.size()));
					}
					case GetValue(var index) -> {
						out.writeData(new Value(l.get(index)));
					}
					case Stop() -> {
						done = true;
					}
				}
			}
		} catch (Exception e) {
			throw new Error(e);
		}
	}

}
