package net.lecnam.info.ex4;

import java.util.logging.Level;
import java.util.logging.Logger;

public class Client implements Runnable {

	AnswerReader in;
	RequestWriter out;

	Logger logger = Logger.getLogger("Client");

	Client(AnswerReader in, RequestWriter out) {
		this.in = in;
		this.out = out;
		logger.setLevel(Level.ALL);
	}

	int size() {
		try {
			out.writeData(new GetSize());
			Answer answer = in.readData();
			switch (answer) {
				case Size(var s) -> {
					return s;
				}
				default -> {
					throw new Error("Size expected");
				}
			}
		} catch (Exception e) {
			throw new Error(e);
		}
	}

	String get(int index) {
		try {
			out.writeData(new GetValue(index));
			Answer answer = in.readData();
			switch (answer) {
				case Value(var elt) -> {
					return elt;
				}
				default -> {
					throw new Error("Value expected");
				}
			}
		} catch (Exception e) {
			throw new Error(e);
		}
	}

	void close() {
		try {
			out.writeData(new Stop());
		} catch (Exception e) {
			throw new Error(e);
		}
	}

	@Override
	public void run() {
		logger.info("Client is running...");
		for (int i = 0; i < size(); i++) {
			System.out.println(get(i));
		}
		close();
	}

}
