package net.lecnam.info.ex3;

import static net.lecnam.info.util.Pair.pair;

import java.util.List;

import net.lecnam.info.util.Pair;


sealed interface Token {}
record T_Int(Integer i) implements Token {}
record T_Ident(String s) implements Token {}
record T_String(String s) implements Token {}
record T_LANGLE() implements Token {}
record T_RANGLE() implements Token {}
record T_LCURL() implements Token {}
record T_RCURL() implements Token {}
record T_LSQUARE() implements Token {}
record T_RSQUARE() implements Token {}
record T_COMMA() implements Token {}
record T_COLON() implements Token {}
record T_EQUAL() implements Token {}
record T_UNKNOWN() implements Token {}


public class Tokens {

    public static List<Pair<String, Token>> symbols = List.of(
            pair("<", new T_LANGLE()),
            pair(">", new T_RANGLE()),
            pair("{", new T_LCURL()),
            pair("}", new T_RCURL()),
            pair("[", new T_LSQUARE()),
            pair("]", new T_RSQUARE()),
            pair(",", new T_COMMA()),
            pair(":", new T_COLON()),
            pair("=", new T_EQUAL())
        );

}

