package net.lecnam.info.ex3;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import net.lecnam.info.util.Pair;

record LocToken(Token tok, Integer line) {}

sealed interface TokenSeq {}
record TokenSeqImpl(LinkedList<LocToken> l) implements TokenSeq {}


public class TokenSeqs {


    public static TokenSeq makeSeq(List<LocToken> l) {
        var tokens = Collections.unmodifiableCollection(l);
        return new TokenSeqImpl(new LinkedList<>(tokens));
    }

    public static Boolean isEmpty(TokenSeq s) {
        return switch (s) {
            case TokenSeqImpl(var r) -> {
                yield r.isEmpty();
            }
        };
    }

    public static LocToken peek(TokenSeq s) {
        return switch (s) {
            case TokenSeqImpl(var r) -> {
                yield r.peek();
            }
        };
    }

    public static LocToken remove(TokenSeq s) {
        return switch (s) {
            case TokenSeqImpl(var r) -> {
                yield r.remove();
            }
        };
    }

    public static Integer getFirstLine(TokenSeq l) {
        var lc = peek(l);
        return lc.line();
    }

    public static LocToken locToken(Pair<Token, Integer> p) {
        LocToken locToken = new LocToken(p.fst(), p.snd());
        return locToken;
    }

}

