package net.lecnam.info.ex3;

import static net.lecnam.info.util.ImmutableList.hd;
import static net.lecnam.info.util.ImmutableList.nil;

import java.util.List;
import java.util.Objects;

public class RequestPrinter {

	static String stringOf(Request r) {
		return switch (r) {
			case GetSize() -> "{ " + "\"@type\"" + " : " + "\"GetSize\"" + " }";
			case GetValue(var index) -> "{ " + "\"@type\"" + " : " + "\"GetValue\""
					+ ", " + "\"index\"" + " : " + index + " }";
			case Stop() -> "{ " + "\"@type\"" + " : " + "\"Stop\"" + " }";
			default -> throw new Error("Unexpected case");
		};
	}


	public static void main(String[] args) {
		Request r1 = new GetSize();
		Request r2 = new Stop();
		Request r3 = new GetValue(5);
		System.out.println(stringOf(r1));
		System.out.println(stringOf(r2));
		System.out.println(stringOf(r3));		
	}
}
