package net.lecnam.info.ex3;

import static net.lecnam.info.ex3.Lexer.readLines;
import static net.lecnam.info.ex3.TokenSeqs.getFirstLine;
import static net.lecnam.info.ex3.TokenSeqs.makeSeq;
import static net.lecnam.info.ex3.TokenSeqs.remove;
import static net.lecnam.info.util.ImmutableList.hd;
import static net.lecnam.info.util.ImmutableList.nil;

import java.io.FileReader;
import java.io.Reader;
import java.util.List;
import java.util.Objects;

public class AnswerParser {


    public static void parse(TokenSeq s, Token t) {
        var h = remove(s);
        if (Objects.equals(h.tok(), t)) {
            return;
        } else {
            throw new Error("Unexpected token line " + String.valueOf(h.line()));
        }
    }

    public static String parseString(TokenSeq s) {
        var h = remove(s);
        switch (h.tok()) {
            case T_String(var name) -> {
                return name;
            }
            default -> {
                throw new Error("String expected line " + String.valueOf(h.line()));
            }
        }
    }

    public static Integer parseInt(TokenSeq s) {
        var h = remove(s);
        switch (h.tok()) {
            case T_Int(var i) -> {
                return i;
            }
            default -> {
                throw new Error("Integer expected line " + String.valueOf(h.line()));
            }
        }
    }

    public static Answer parseAnswer(TokenSeq s) {
        parse(s, new T_LCURL());
        parse(s, new T_String("@type"));
        parse(s, new T_COLON());
        var name = parseString(s);
        switch (name) {
            case "Size" -> {
                parse(s, new T_COMMA());
                parse(s, new T_String("index"));
                parse(s, new T_COLON());
                var index = parseInt(s);
                parse(s, new T_RCURL());
                return new Size(index);
            }
            case "Value" -> {
                parse(s, new T_COMMA());
                parse(s, new T_String("element"));
                parse(s, new T_COLON());
                var element = parseString(s);
                parse(s, new T_RCURL());
                return new Value(element);
            }
            default -> {
                throw new Error("Unknown record name line " + String.valueOf(getFirstLine(s)));
            }
        }
    }


    public static Answer parseAnswerWithReader(Reader reader) {
        try {
            var content = readLines(reader);
            var tokens = makeSeq(Lexer.lexer(content));
            return parseAnswer(tokens);
        } catch (Exception err) {
            throw new Error(err);
        }
    }

    public static Answer parseAnswerFromFile(String filename) {
        try {
            var reader = new FileReader(filename);
            return parseAnswerWithReader(reader);
        } catch (Exception err) {
            throw new Error(err);
        }
    }

    public static void run(List<String> args) {
        var filename = (Objects.equals(args, nil())) ? "src/main/resources/test.json" : hd(args);
        var result = parseAnswerFromFile(filename);
        System.out.println(result);
        //System.out.println(Pretty.stringOf(result));
        return;
    }

    public static void main(String[] args) {
        run(List.of(args));
    }
}

