package net.lecnam.info.ex1;

import static net.lecnam.info.util.ImmutableList.hd;
import static net.lecnam.info.util.ImmutableList.nil;

import java.util.List;
import java.util.Objects;

public class Pretty {

	static String stringOf(Expr e) {
		return switch (e) {
			case Const(var i) -> "{ " + "\"@type\"" + " : " + "\"Const\"" + ", "
					+ "\"i\"" + " : " + i.toString() + " }";
			case Minus(var e1) -> "{ " + "\"@type\"" + " : " + "\"Minus\""
					+ ", " + "\"e\"" + " : " + stringOf(e1) + " }";
			case Plus(var e1, var e2) -> "{ " + "\"@type\"" + " : " + "\"Plus\""
					+ ", " + "\"e1\"" + " : " + stringOf(e1) + ", " + "\"e2\""
					+ " : " + stringOf(e2) + " }";
			case Times(var e1, var e2) -> "{ " + "\"@type\"" + " : "
					+ "\"Times\"" + ", " + "\"e1\"" + " : " + stringOf(e1)
					+ ", " + "\"e2\"" + " : " + stringOf(e2) + " }";
			default -> throw new Error("Unexpected case");
		};
	}

	public static String pretty(String name) {
		Parser.parseExprFromFile(name);
		return "";
	}

	public static void run(List<String> args) {
		var filename = (Objects.equals(args, nil())) ? "test.json" : hd(args);
		var result = pretty(filename);
		System.out.print(result);
		return;
	}

	public static void main(String[] args) {
		run(List.of(args));
	}
}
