package net.lecnam.info.ex7;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Logger;

public class Server<E> implements Runnable {
	
	BlockingQueue<Request<E>> in;
	BlockingQueue<Answer<E>> out;
	List<E> l;
	
	static final Logger logger = Logger.getLogger("server");
	
	Server(BlockingQueue<Request<E>> in, BlockingQueue<Answer<E>> out, List<E> l) {
		this.in = in;
		this.out = out;
		this.l = new ArrayList<>(l);
	}
	
	@Override
	public void run() {
		try {
			boolean done = false;
			while (!done) {
				Request<E> request = in.take();
				logger.info("Request: " + request);
				switch (request) {
					case Stop() -> {
						done = true;
					}
					case GetSize() -> {
						int s = l.size();
						Answer<E> answer = new Size<>(s);
						out.put(answer);
					}
					case GetValue(var index) -> {
						E elt = l.get(index);
						Answer<E> answer = new Value<>(elt);
						out.put(answer);
					}
					case Set(var index, var element) -> {
						E old = l.set(index, element);
						Answer<E> answer = new OldValue<>(old);
						out.put(answer);
					}						
					case Add(var index, var element) -> {
						l.add(index, element);
						Answer<E> answer = new Done<>();
						out.put(answer);						
					}
					case Remove(var index) -> {
						E old = l.remove(index);
						Answer<E> answer = new OldValue<>(old);
						out.put(answer);					
					}
				}
			}
		} catch (InterruptedException ex) {
			throw new Error(ex);
		}
	}
	
}
