package net.lecnam.info.ex7;

import java.util.AbstractList;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Logger;
import net.lecnam.info.ex7.Answer.*;
import net.lecnam.info.ex7.Request.*;

public class RemoteList<E> extends AbstractList<E> {

	BlockingQueue<Answer<E>> in;
	BlockingQueue<Request<E>> out;

	RemoteList(BlockingQueue<Answer<E>> in, BlockingQueue<Request<E>> out) {
		this.in = in;
		this.out = out;
	}

	static final Logger logger = Logger.getLogger("server");

	@Override
	public int size() {
		try {
			Request<E> request = new GetSize<E>();
			out.put(request);
			Answer answer = in.take();
			logger.info("Answer: " + answer);
			switch (answer) {
				case Size(var s) -> {
					return s;
				}
				default -> {
					throw new Error("Invalid answer");
				}
			}
		} catch (InterruptedException ex) {
			throw new Error(ex);
		}
	}

	@Override
	public E get(int index) {
		try {
			Request<E> request = new GetValue<E>(index);
			out.put(request);
			Answer<E> answer = in.take();
			logger.info("Answer: " + answer);
			switch (answer) {
				case Value(var elt) -> {
					return elt;
				}
				default -> {
					throw new Error("Invalid answer");
				}
			}
		} catch (InterruptedException ex) {
			throw new Error(ex);
		}
	}

	@Override
	public E set(int index, E element) {
		try {
			Request<E> request = new Set<E>(index, element);
			out.put(request);
			Answer<E> answer = in.take();
			logger.info("Answer: " + answer);
			switch (answer) {
				case OldValue(var elt) -> {
					return elt;
				}
				default -> {
					throw new Error("Invalid answer");
				}
			}
		} catch (InterruptedException ex) {
			throw new Error(ex);
		}
	}

	@Override
	public E remove(int index) {
		try {
			Request<E> request = new Remove<E>(index);
			out.put(request);
			Answer<E> answer = in.take();
			logger.info("Answer: " + answer);
			switch (answer) {
				case OldValue(var elt) -> {
					return elt;
				}
				default -> {
					throw new Error("Invalid answer");
				}
			}
		} catch (InterruptedException ex) {
			throw new Error(ex);
		}
	}

	@Override
	public void add(int index, E element) {
		try {
			Request<E> request = new Add<>(index, element);
			out.put(request);
			Answer<E> answer = in.take();
			logger.info("Answer: " + answer);
			switch (answer) {
				case Done() -> {
					return;
				}
				default -> {
					throw new Error("Invalid answer");
				}
			}
		} catch (InterruptedException ex) {
			throw new Error(ex);
		}
	}

	public void stop() {
		try {
			Request<E> request = new Stop<>();
			out.put(request);
		} catch (InterruptedException ex) {
			throw new Error(ex);
		}
	}

}
