package net.lecnam.info.ex6;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Logger;

public class Server<E> implements Runnable {

	BlockingQueue<Request> in;
	BlockingQueue<Answer<E>> out;
	List<E> l;

	Logger logger = Logger.getLogger("Server");

	Server(BlockingQueue<Request> in, BlockingQueue<Answer<E>> out, List<E> l) {
		this.in = in;
		this.out = out;
		this.l = l;
	}

	@Override
	public void run() {
		logger.info("Server is running...");
		try {
			Request request = null;
			boolean done = false;
			while (!done) {
				request = in.take();
				switch (request) {
					case GetSize() -> {
						out.put(new Size<>(l.size()));
					}
					case GetValue(var index) -> {
						out.put(new Value<>(l.get(index)));
					}
					case Stop() -> {
						done = true;
					}
				}
			}
		} catch (InterruptedException e) {
			throw new Error(e);
		}
	}

}
