package net.lecnam.info.ex6;

import java.util.AbstractList;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteList<E> extends AbstractList<E> {

	BlockingQueue<Answer<E>> in;
	BlockingQueue<Request> out;

	Logger logger = Logger.getLogger("Client");

	RemoteList(BlockingQueue<Answer<E>> in, BlockingQueue<Request> out) {
		this.in = in;
		this.out = out;
		logger.setLevel(Level.ALL);
	}

	public int size() {
		try {
			out.put(new GetSize());
			Answer<E> answer = in.take();
			switch (answer) {
				case Size<E>(Integer index) -> {
					return index;
				}
				default -> {
					throw new Error("Size expected");
				}
			}
		} catch (InterruptedException e) {
			throw new Error(e);
		}
	}
	
	public E get(int index) {
		try {
			out.put(new GetValue(index));
			Answer<E> answer = in.take();
			switch (answer) {
				case Value<E>(E element) -> {
					return element;
				}
				default -> {
					throw new Error("Value expected");
				}
			}
		} catch (InterruptedException e) {
			throw new Error(e);
		}
	}

	public void close() {
		try {
			out.put(new Stop());
		} catch (InterruptedException e) {
			throw new Error(e);
		}
	}

}
