package net.lecnam.info.ex6;

import java.util.concurrent.BlockingQueue;
import java.util.logging.Logger;

public class Client implements Runnable {

	BlockingQueue<Answer<String>> in;
	BlockingQueue<Request> out;
	RemoteList<String> l;

	Logger logger = Logger.getLogger("Client");

	Client(BlockingQueue<Answer<String>> in, BlockingQueue<Request> out) {
		this.in = in;
		this.out = out;
		this.l = new RemoteList<String>(in, out);
	}

	@Override
	public void run() {
		logger.info("Client is running...");
		for (String s: l) {
			System.out.println(s);
		}
		l.close();
	}

}
