package net.lecnam.info.ex5;

import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Client<E> implements Runnable {

	BlockingQueue<Answer<E>> in;
	BlockingQueue<Request> out;

	Logger logger = Logger.getLogger("Client");

	Client(BlockingQueue<Answer<E>> in, BlockingQueue<Request> out) {
		this.in = in;
		this.out = out;
		logger.setLevel(Level.ALL);
	}

    public int size() {
      try {
          out.put(new GetSize());
          Answer<E> answer = in.take();
          switch (answer) {
              case Size<E>(var index) -> {
                  return index;
              }
              default -> {
                  throw new Error("Size expected");
              }
          }
      } catch (InterruptedException e) {
          throw new Error(e);
      }
  }
  
  public E get(int index) {
      try {
          out.put(new GetValue(index));
          Answer<E> answer = in.take();
          switch (answer) {
              case Value<E>(E element) -> {
                  return element;
              }
              default -> {
                  throw new Error("Value expected");
              }
          }
      } catch (InterruptedException e) {
          throw new Error(e);
      }
  }

	void close() {
		try {
			out.put(new Stop());
		} catch (InterruptedException e) {
			throw new Error(e);
		}
	}

	@Override
	public void run() {
		logger.info("Client is running...");
		for (int i = 0; i < size(); i++) {
			System.out.println(get(i));
		}
		close();
	}

}
