package net.lecnam.info.ex4;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Logger;

public class Server implements Runnable {

	BlockingQueue<Request> in;
	BlockingQueue<Answer> out;
	List<String> l = Arrays.asList("A", "B", "C", "7", "9", "11", "13", "17");

	Logger logger = Logger.getLogger("Server");

	Server(BlockingQueue<Request> in, BlockingQueue<Answer> out) {
		this.in = in;
		this.out = out;
	}

	@Override
	public void run() {
		logger.info("Server is running...");
		try {
			Request request = null;
			boolean done = false;
			while (!done) {
				request = in.take();
				switch (request) {
					case GetSize() -> {
						out.put(new Size(l.size()));
					}
					case GetValue(var index) -> {
						out.put(new Value(l.get(index)));
					}
					case Stop() -> {
						done = true;
					}
				}
			}
		} catch (InterruptedException e) {
			throw new Error(e);
		}
	}

}
