package net.lecnam.info.ex4;

import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Client implements Runnable {

	BlockingQueue<Answer> in;
	BlockingQueue<Request> out;

	Logger logger = Logger.getLogger("Client");

	Client(BlockingQueue<Answer> in, BlockingQueue<Request> out) {
		this.in = in;
		this.out = out;
		logger.setLevel(Level.ALL);
	}

	int size() {
		try {
			out.put(new GetSize());
			Answer answer = in.take();
			switch (answer) {
				case Size(var s) -> {
					return s;
				}
				default -> {
					throw new Error("Size expected");
				}
			}
		} catch (InterruptedException e) {
			throw new Error(e);
		}
	}
	
	String get(int index) {
		try {
			out.put(new GetValue(index));
			Answer answer = in.take();
			switch (answer) {
				case Value(var elt) -> {
					return elt;
				}
				default -> {
					throw new Error("Value expected");
				}
			}
		} catch (InterruptedException e) {
			throw new Error(e);
		}
	}

	void close() {
		try {
			out.put(new Stop());
		} catch (InterruptedException e) {
			throw new Error(e);
		}
	}

	@Override
	public void run() {
		logger.info("Client is running...");
		for (int i = 0; i < size(); i++) {
			System.out.println(get(i));
		}
		close();
	}

}
