package net.lecnam.info.ex2;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;

public class Server implements Runnable {

	BlockingQueue<Integer> in;
	BlockingQueue<Either<Integer, String>> out;
	List<String> l = Arrays.asList("A", "Z", "E", "R", "T", "Y");

	Server(BlockingQueue<Integer> in,
			BlockingQueue<Either<Integer, String>> out) {
		this.in = in;
		this.out = out;
	}

	@Override
	public void run() {
		try {
			int request = 0;
			while (request != -1) {
				request = in.take();
				if (request == -2) {
					Integer size = l.size();
					out.put(new Left<>(size));
				} else {
					if (request >= 0) {
						String value = l.get(request);
						out.put(new Right<>(value));
					}
				}
			}
		} catch (InterruptedException exn) {
			throw new Error(exn);
		}
	}

}
