package net.lecnam.info.ex2;

import java.util.concurrent.BlockingQueue;
import java.util.logging.Logger;

public class Client implements Runnable {

	Logger logger = Logger.getLogger("Client");

	BlockingQueue<Either<Integer, String>> in;
	BlockingQueue<Integer> out;

	Client(BlockingQueue<Either<Integer, String>> in,
			BlockingQueue<Integer> out) {
		this.in = in;
		this.out = out;
	}

	int size() {
		try {
			out.put(-2);
			Either<Integer, String> answer = in.take();
			return switch (answer) {
				case Left<Integer, String> left -> left.value();
				case Right<Integer, String> right -> throw new Error("Size expected");
			};
		} catch (InterruptedException exn) {
			throw new Error(exn);
		}
	}

	String get(int i) {
		try {
			out.put(i);
			Either<Integer, String> answer = in.take();
			return switch (answer) {
				case Left<Integer, String> left -> {
					throw new Error("Value expected");
				}
				case Right<Integer, String> right -> {
					yield right.value();
				}
			};
		} catch (InterruptedException exn) {
			throw new Error(exn);
		}
	}

	void close() {
		try {
			out.put(-1);
		} catch (InterruptedException exn) {
			throw new Error(exn);
		}
	}

	@Override
	public void run() {
		for (int i = 0; i < size(); i++) {
			String value = get(i);
			System.out.println(value);
		}
		close();
	}

}
