package net.lecnam.info.ex1;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Logger;

public class Server implements Runnable {

	BlockingQueue<Integer> in;
	BlockingQueue<Integer> out;
	List<Integer> l = Arrays.asList(1, 3, 5, 7, 9, 11, 13, 17);

	Logger logger = Logger.getLogger("Server");

	Server(BlockingQueue<Integer> in, BlockingQueue<Integer> out) {
		this.in = in;
		this.out = out;
	}

	@Override
	public void run() {
		logger.info("Server is running...");
		try {
			int request = 0;
			boolean done = false;
			while (!done) {
				request = in.take();
				if (request == -2) {
					out.put(l.size());
				} else {
					if (request == -1) {
						done = true;
					} else {
						out.put(l.get(request));
					}
				}
			}
		} catch (InterruptedException e) {
			throw new Error(e);
		}
	}

}
