package net.lecnam.info.ex1;

import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Client implements Runnable {

	BlockingQueue<Integer> in;
	BlockingQueue<Integer> out;

	Logger logger = Logger.getLogger("Client");

	Client(BlockingQueue<Integer> in, BlockingQueue<Integer> out) {
		this.in = in;
		this.out = out;
		logger.setLevel(Level.ALL);
	}

	int size() {
		try {
			out.put(-2);
			var s = in.take();
			return s;
		} catch (InterruptedException e) {
			throw new Error(e);
		}
	}
	
	int get(int index) {
		try {
			out.put(index);
			var elt = in.take();
			return elt;
		} catch (InterruptedException e) {
			throw new Error(e);
		}
	}

	void close() {
		try {
			out.put(-1);
		} catch (InterruptedException e) {
			throw new Error(e);
		}
	}

	@Override
	public void run() {
		logger.info("Client is running...");
		for (int i = 0; i < size(); i++) {
			System.out.println(get(i));
		}
		close();
	}

}
