package net.lecnam.info;

import static net.lecnam.info.FormUtil.*;

public class Main {

	public static void main(String[] args) {
		var f1 = new And(new Top(), new Bottom());
		var f2 = new Or(new Top(), new Not(new Not(f1)));
		var f3 = new Or(f2, f2);
		System.out.println(f1);
		System.out.println(f2);
		System.out.println(stringOf(f1));
		System.out.println(stringOf(f2));
		System.out.println("f1:" + eval(f1));
		System.out.println("f2:" + eval(f2));
		System.out.println(simpl(f2));
		System.out.println(stringOf(simpl(f2)));
		System.out.println(stringOf(f3));
		System.out.println(stringOf(simpl(f3)));
		System.out.println("Done.");
		
		var e1 = new Plus(new Const(4), new Const(5));
		var e2 = new Times(new Const(3), new Const(7));
		var e3 = subtract(new Const(10), e2);
		System.out.println(stringOf(e1));
		System.out.println(stringOf(e2));
		System.out.println(stringOf(e3));
		System.out.println("e1:" + eval(e1));
		System.out.println("e2:" + eval(e2));
		System.out.println("e3:" + eval(e3));
		
		System.out.println(stringOf(f1));
		System.out.println(stringOf(translate(f1)));
		System.out.println("f1:" + eval(f1));
		System.out.println("f1:" + eval(translate(f1)));
		System.out.println("f1:" + eval2(f1));
		
		System.out.println(stringOf(f2));
		System.out.println(stringOf(translate(f2)));
		System.out.println("f1:" + eval(f2));
		System.out.println("f1:" + eval(translate(f2)));
		System.out.println("f1:" + eval2(f2));
		
	}
}
