package net.lecnam.info;

public class FormUtil {

	static String stringOf(Form f) {
		return switch(f) {
			case Top() -> "T";
			case Bottom() -> "F";
			case Not(var f1) -> "(not " + stringOf(f1) + ")";
			case And(var f1, var f2) -> "(" + stringOf(f1) + " and " + stringOf(f2) + ")";
			case Or(var f1, var f2) -> "(" + stringOf(f1) + " or " + stringOf(f2) + ")";
		};
	}

	static Boolean eval(Form f) {
		return switch(f) {
			case Top() -> true;
			case Bottom() -> false;
			case Not(var f1) -> !eval(f1);
			case And(var f1, var f2) -> eval(f1) && eval(f2);
			case Or(var f1, var f2) -> eval(f1) || eval(f2);
		};
	}

	static Boolean eval21(Form f) {
		switch(f) {
			case Top() -> {
			    return true;
			}
			case Bottom() -> {
			    return false;
			}
			case Not(var f1) -> {
			    return !eval21(f1);
			}
			case And(var f1, var f2) -> {
			    return eval21(f1) && eval21(f2);
			}
			case Or(var f1, var f2) -> {
			    return eval21(f1) || eval21(f2);
			}
			default -> throw new IllegalStateException();
		}
	}

	static Form imply(Form f1, Form f2) {
		return new Or(new Not(f1), f2);
	}
	
	static Form simpl(Form f) {
		return switch(f) {
			case Top() -> f;
			case Bottom() -> f;
			case Not(var f1) -> 
				switch(f1) {
					case Not(var f2) -> simpl(f2);
					default -> new Not(simpl(f1));
				};
			case And(var f1, var f2) -> new And(simpl(f1), simpl(f2));
			case Or(var f1, var f2) -> new Or(simpl(f1), simpl(f2));
		};		
	}

	static String stringOf(Expr e) {
		return switch (e) {
			case Const(var i) -> i.toString();
			case Minus(var e1) -> "(-" + stringOf(e1) + ")";
			case Plus(var e1,var e2) -> "(" + stringOf(e1) + " + " + stringOf(e2) + ")";
			case Times(var e1,var e2) ->"(" + stringOf(e1) + " * " + stringOf(e2) + ")";
		};
	}
	
	static Integer eval(Expr e) {
		return switch (e) {
			case Const(var i) -> i;
			case Minus(var e1) -> -eval(e1);
			case Plus(var e1, var e2) -> eval(e1) + eval(e2);
			case Times(var e1, var e2) -> eval(e1) * eval(e2);
		};
	}

	static Expr subtract(Expr e1, Expr e2) {
		return new Plus(e1, new Minus(e2));
	}
	
	static Form oper(Form f1, Form f2) {
		return new Not(new And(new Not(f1), new Not(f2)));
	}
	
	static Expr translate(Form f) {
		return switch(f) {
			case Top() -> new Const(1);
			case Bottom() -> new Const(0);
			case Not(var f1) -> subtract(new Const(1), translate(f1));
			case And(var f1, var f2) -> new Times(translate(f1), translate(f2));
			case Or(var f1, var f2) -> translate(oper(f1, f2));
		};
	}
	
	static Boolean eval2(Form f) {
		return 1 == eval(translate(f));
	}

}
