package net.lecnam.info;

import static org.junit.jupiter.api.Assertions.*;

import static net.lecnam.info.ImmutableList.cons;
import static net.lecnam.info.ImmutableList.nil;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;


class ImmutableListTest {

	ImmutableList<Integer> list;
	
	@BeforeEach
	void setUp() throws Exception {
		list = cons(1, cons(2, cons(3, cons(4, cons(5, cons(6, nil()))))));
	}

	@Test
	void testSize() {
		int expected = 6;
		int actual = list.size();
		assertEquals(expected, actual);
	}

	@Test
	void testGetInt() {
		int expected = 4;
		int actual = list.get(3);
		assertEquals(expected, actual);
	}

}
