package net.lecnam.info;

import java.util.Objects;

//sealed interface SimpleList<A> {}
//record Nil<A>() implements SimpleList<A> {}
//record Cons<A>(A head, SimpleList<A> tail) implements SimpleList<A> {}

interface SimpleList<A> {

	class Nil<A> implements SimpleList<A> {

		public Nil() {
			super();
		}

		@Override
		public int hashCode() {
			return Objects.hash();
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			return true;
		}

		@Override
		public String toString() {
			return "Nil []";
		}

	}

	class Cons<A> implements SimpleList<A> {

		final private A head; 
		final private SimpleList<A> tail;

		public Cons(A head, SimpleList<A> tail) {
			super();
			this.head = head;
			this.tail = tail;
		}

		@Override
		public int hashCode() {
			return Objects.hash(head, tail);
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			var other = (Cons<?>) obj;
			return Objects.equals(head, other.head)
					&& Objects.equals(tail, other.tail);
		}

		@Override
		public String toString() {
			return "Cons [head=" + head + ", tail=" + tail + "]";
		}

	}

}
