package net.lecnam.info;

import static net.lecnam.info.ImmutableList.cons;
import static net.lecnam.info.ImmutableList.nil;

public class Main {

	static <A> int length(ImmutableList<A> l) {
		switch (l) {
			case Nil<A> n:
				return 0;
			case Cons<A> c: {
				var t = c.tl();
				return 1 + length(t);
			}
			default: throw new IllegalArgumentException();
		}
	}

	public static void main(String[] args) {
		var l = cons(3, cons(2, cons(1, nil())));
		System.out.println(l);
		System.out.println(ListUtil.length(l));
		System.out.println(ListUtil.sum(l));
		System.out.println("Done.");
	}
}
