package net.lecnam.info;

import net.lecnam.info.ImmutableList.ListVisitor;

public class ListUtil {

//	static <A> int length(ImmutableList<A> l) {
//		if (l.isEmpty()) {
//			return 0;
//		} else {
//			var t = l.tl();
//			return 1 + length(t);
//		}
//	}
	
	static <A> int length(ImmutableList<A> l) {
		var v = new ListVisitor<Integer,A>() {

			@Override
			public Integer visitNil() {
				return 0;
			}

			@Override
			public Integer visitCons(A h, ImmutableList<A> t) {
				return 1 + length(t);
			}
		};
		return l.accept(v);
	}

	static int sum(ImmutableList<Integer> l) {
		var v = new ListVisitor<Integer,Integer>() {

			@Override
			public Integer visitNil() {
				return 0;
			}

			@Override
			public Integer visitCons(Integer h, ImmutableList<Integer> t) {
				return h + sum(t);
			}
		};
		return l.accept(v);
	}

}
