package net.lecnam.info;

import static org.junit.jupiter.api.Assertions.*;

import java.util.stream.IntStream;

import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvFileSource;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.MethodSource;

class CalculatorTest {

	Calculator calc = new Calculator();

	@Test
	void testAdd() {
		int actual = calc.add(2, 3);
		int expected = 5;
		assertEquals(expected, actual);
	}

	@Test
	void testDiv() {
		int actual = calc.div(66, 3);
		int expected = 22;
		assertEquals(expected, actual);
	}

	@Test
	void testDiv2() {
		try {
			int actual = calc.div(66, 0);
		} catch (Exception e) {
			assertTrue(e instanceof ArithmeticException);
		}
	}

	@DisplayName("Division by non zero")
	@Test
	void testDivide() {
		int actual = calc.divide(66, 3);
		int expected = 22;
		assertEquals(expected, actual);
	}

	@DisplayName("Division by zero")
	@Test
	void testDivide2() {
		try {
			int actual = calc.divide(66, 0);
		} catch (Exception e) {
			assertTrue(e instanceof ArithmeticException);
		}
	}

	@Disabled
	@Test
	void testProd() {
		int actual = calc.prod(6, 3);
		int expected = 18;
		assertEquals(expected, actual);
	}

	@Disabled
	@Test
	void testProd2() {
		int actual = calc.prod(0, 0);
		int expected = 0;
		assertEquals(expected, actual);
	}

	@Disabled
	@Test
	void testProd3() {
		int actual = calc.prod(0, 8);
		int expected = 0;
		assertEquals(expected, actual);
	}

	@Disabled
	@ParameterizedTest
	@CsvSource({"6, 3, 18", "1, 0, 0", "1, 1, 1", "5, 4, 20"})
	void testProdParam(int x, int y, int expected) {
		int actual = calc.prod(x, y);
		assertEquals(expected, actual);
	}

	@ParameterizedTest
	@CsvFileSource(resources = "/testProd2.csv", numLinesToSkip = 1)
	void testProd2(int x, int y, int expected) {
		int actual = calc.prod(x, y);
		assertEquals(expected, actual);
	}

	@Test
	void testShortest1() {
		String actual = calc.shortest("a", "bb", "ccc");
		String expected = "a";
		assertEquals(expected, actual);
	}

	@Test
	void testShortest2() {
		String actual = calc.shortest("aa", "b", "ccc");
		String expected = "b";
		assertEquals(expected, actual);
	}

	@Test
	void testShortest3() {
		String actual = calc.shortest("aaa", "bb", "c");
		String expected = "c";
		assertEquals(expected, actual);
	}

	@Test
	void testShortest4() {
		String actual = calc.shortest("aa", "bbb", "c");
		String expected = "c";
		assertEquals(expected, actual);
	}

	@ParameterizedTest
	@CsvFileSource(resources = "/testShortest.csv", numLinesToSkip = 1)
	void testShortestParam(String x, String y, String z, String expected) {
		String actual = calc.shortest(x, y, z);
		assertEquals(expected, actual);
	}

	static IntStream range() {
		return IntStream.range(0, 20).skip(10);
	}

	@ParameterizedTest
	@MethodSource("range")
	void testWithRangeMethodSource(int x) {
		int actual = calc.add(x, x);
		int expected = 2 * x;
		assertEquals(expected, actual);
	}
	
	@ParameterizedTest
	@CsvFileSource(resources = "/testShortest.csv", numLinesToSkip = 1)
	void testShortestParam2(String x, String y, String z, String unused) {
		String actual = calc.shortest(x, y, z);
		assertTrue(        
				actual.length() <= x.length() &&
				actual.length() <= y.length() &&
				actual.length() <= z.length()  &&
				(actual == x || actual == y || actual == z)
				);
	}

}
