package net.lecnam.info;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;

abstract class Server<V> implements Runnable {

    Callable<V> callable;
    BlockingQueue<V> queue;

    public Server(Callable<V> callable) {
        this.callable = callable;
        this.queue = new LinkedBlockingQueue<>();
    }

    @Override
    public void run() {
        try {
            V result = callable.call();
            queue.put(result);
        } catch (Exception ex) {
            throw new Error(ex);
        }
    }
}
