package net.lecnam.info;

import static net.lecnam.info.FutureTask.futureTask;
import static net.lecnam.info.ImmutableList.*;

import java.util.concurrent.ExecutionException;

public class MergeSort {

	// take the first i elements from the given list
	static <A> ImmutableList<A> take(ImmutableList<A> l, Integer i) {
		if (l.isEmpty()) {
			if (i == 0) {
				return nil();
			} else {
				throw new IndexOutOfBoundsException();
			}
		} else {
			var h = l.hd();
			var t = l.tl();
			if (i == 0) {
				return nil();
			} else {
				return cons(h, take(t, i - 1));
			}
		}
	}

	// drop the first i elements from the given list
	static <A> ImmutableList<A> drop(ImmutableList<A> l, Integer i) {
		if (l.isEmpty()) {
			if (i == 0) {
				return nil();
			} else {
				throw new IndexOutOfBoundsException();
			}
		} else {
			var t = l.tl();
			if (i == 0) {
				return l;
			} else {
				return drop(t, i - 1);
			}
		}
	}

	// merge two sorted lists into one sorted list in one pass
	static ImmutableList<Integer> merge(ImmutableList<Integer> l1,
			ImmutableList<Integer> l2) {
		if (l1.isEmpty()) {
			return l2;
		} else {
			var h1 = l1.hd();
			var t1 = l1.tl();
			if (l2.isEmpty()) {
				return l1;
			} else {
				var h2 = l2.hd();
				var t2 = l2.tl();
				if (h1 < h2) {
					return cons(h1, merge(t1, l2));
				} else {
					return cons(h2, merge(l1, t2));
				}
			}
		}
	}

	// recursive version of mergesort
	static ImmutableList<Integer> sortRec(ImmutableList<Integer> l) {
		if (l.size() <= 1) {
			return l;
		}
		var n = l.size() / 2;
		var l1 = take(l, n);
		var l2 = drop(l, n);
		var sl1 = sortRec(l1);
		var sl2 = sortRec(l2);
		return merge(sl1, sl2);
	}

	// parallel version with futures a
	static FutureTask<ImmutableList<Integer>> sortPara(
			ImmutableList<Integer> l) {
		if (l.size() <= 1) {
			return futureTask(() -> l);
		}
		var n = l.size() / 2;
		var l1 = take(l, n);
		var l2 = drop(l, n);
		var f1 = sortPara(l1);
		var f2 = sortPara(l2);
		return f1.flatMap(sl1 -> f2.map(sl2 -> merge(sl1, sl2)));
	}

	public static void main(String[] args)
			throws InterruptedException, ExecutionException {

		var l = ImmutableList.of(2, 7, 9, 6, 3);

		System.out.println("sortRec");
		System.out.println(sortRec(l));

		System.out.println("sortPara");
		System.out.println(sortPara(l).get());
	}

}
