package net.lecnam.info;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

public class FutureTask<V> extends Server<V> implements RunnableFuture<V> {

	V result;
    boolean done = false;

    public FutureTask(Callable<V> callable) {
		super(callable);
	}

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCancelled() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDone() {
    	if (done)
    		return true;
    	else
    		return (queue.peek() != null);
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        if (!done) {
            result = queue.take();
            done = true;
        }
        return result;
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!done) {
            result = queue.poll(timeout, unit);
            done = true;
        }
        return result;
    }

    static <V> FutureTask<V> futureTask(Callable<V> callable) {
		FutureTask<V> future = new FutureTask<>(callable);
		Thread.startVirtualThread(future);
		return future;
	}

    <T> FutureTask<T> map(Function<V, T> f) {
        return futureTask(() -> f.apply(get()));
    }

    <T> FutureTask<T> flatMap(Function<V, FutureTask<T>> f) {
        return futureTask(() -> f.apply(get()).get());
    }
}
