from hypothesis import strategies as st
from hypothesis import Verbosity, given, settings
from hypothesis.strategies import SearchStrategy

from main import cat, map, reversed


@given(st.text(), st.text())
def test_cat(left: str, right: str) -> None:
    result = cat(left, right)
    assert result.startswith(left)
    assert result.endswith(right)
    assert len(result) == len(left) + len(right)


@given(st.text(st.characters(codec='ascii')), st.text(st.characters(codec='ascii')))
def test_cat_1(left: str, right: str) -> None:
    result = cat(left, right)
    assert result.startswith(left)
    assert result.endswith(right)
    assert len(result) == len(left) + len(right)


def strings() -> SearchStrategy[str]:
    return st.text(st.characters(codec='ascii', categories=(['Ll'])))


@given(strings(), strings())
@settings(max_examples=10, verbosity=Verbosity.verbose)
def test_cat_2(left: str, right: str) -> None:
    result = cat(left, right)
    assert result.startswith(left)
    assert result.endswith(right)
    assert len(result) == len(left) + len(right)
