from collections.abc import Callable


def cat(left: str, right: str) -> str:
    """ Concatenate two given strings."""
    return left + right


def reversed[A](l: list[A]) -> list[A]:
    result: list[A] = []
    for e in l:
        result = [e, *result]
    return result


def map[A, B](f: Callable[[A], B], l: list[A]) -> list[B]:
    result: list[B] = []
    for x in l:
        result += [f(x)]
    return result
