import com.sun.j3d.loaders.objectfile.ObjectFile;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.Scene;
import java.awt.*;
import javax.swing.*;
import com.sun.j3d.utils.universe.*;
import javax.media.j3d.*;
import javax.vecmath.*;
import java.io.*;
import com.sun.j3d.utils.behaviors.mouse.*;

public class ChangePointDeVue extends JFrame {
  private BranchGroup arbreContenus = new BranchGroup();
  SimpleUniverse univers = null;

  public BranchGroup construitScene(String nomFichier) {
    TransformGroup vpTrans = null;
    BoundingSphere domaineInteractionSouris = null;
  
    vpTrans = univers.getViewingPlatform().getViewPlatformTransform();
  
    arbreContenus.addChild(new Axis());
    TransformGroup homothetieTG = new TransformGroup();
    Transform3D t3d = new Transform3D();
    t3d.setScale(0.7);
    homothetieTG.setTransform(t3d);
    arbreContenus.addChild(homothetieTG);
    arbreContenus.addChild(new Axis());
  
    TransformGroup navireTG = new TransformGroup();
    navireTG.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
    navireTG.setCapability(TransformGroup.ALLOW_TRANSFORM_READ);
    homothetieTG.addChild(navireTG);
  
    int flags = ObjectFile.RESIZE;
  
    ObjectFile f = new ObjectFile(flags);
    Scene s = null;
    try {
      s = f.load(nomFichier);
    }
    catch (FileNotFoundException e) {
      System.err.println(e);
      System.exit(1);
    }
    catch (ParsingErrorException e) {
      System.err.println(e);
      System.exit(1);
    }
    catch (IncorrectFormatException e) {
      System.err.println(e);
      System.exit(1);
    }
  
    navireTG.addChild(s.getSceneGroup());
  
    domaineInteractionSouris = new BoundingSphere(new Point3d(),
       1000.0);
  
    MouseRotate rotBtSourisGauche = new MouseRotate(MouseBehavior.INVERT_INPUT);
    rotBtSourisGauche.setTransformGroup(vpTrans);
    rotBtSourisGauche.setSchedulingBounds(domaineInteractionSouris);
    arbreContenus.addChild(rotBtSourisGauche);
  
    MouseTranslate transBtSourisDroit = new MouseTranslate(MouseBehavior.INVERT_INPUT);
    transBtSourisDroit.setTransformGroup(vpTrans);
    transBtSourisDroit.setSchedulingBounds(domaineInteractionSouris);
    arbreContenus.addChild(transBtSourisDroit);
  
    eclairage();
    return arbreContenus;
  }

  private void eclairage() {

    BoundingSphere bounds =
      new BoundingSphere(new Point3d(0.0,0.0,0.0), 100.0);

    // Un bleu "marine" en fond d'cran
    Color3f bgColor = new Color3f(0.05f, 0.05f, 0.5f);
    Background bgNode = new Background(bgColor);
    bgNode.setApplicationBounds(bounds);
    arbreContenus.addChild(bgNode);

    // Une couleur ambiante blanche
    Color3f couleurAmbiante = new Color3f(0.1f, 0.1f, 0.1f);
    AmbientLight lumiereAmbiante = new AmbientLight(couleurAmbiante);
    lumiereAmbiante.setInfluencingBounds(bounds);
    arbreContenus.addChild(lumiereAmbiante);

    // Deux lumires directionnelles une dans chaque sens de 
    // la bissectrice principale du repre 3D
    Color3f lumiere1 = new Color3f(1.0f, 1.0f, 0.9f);
    Vector3f directionLumiere1  = new Vector3f(1.0f, 1.0f, 1.0f);
    Color3f lumiere2 = new Color3f(1.0f, 1.0f, 1.0f);
    Vector3f directionLumiere2  = new Vector3f(-1.0f, -1.0f, -1.0f);

    DirectionalLight lumiereDirectionnelle1
      = new DirectionalLight(lumiere1, directionLumiere1);
    lumiereDirectionnelle1.setInfluencingBounds(bounds);
    arbreContenus.addChild(lumiereDirectionnelle1);

    DirectionalLight lumiereDirectionnelle2
      = new DirectionalLight(lumiere2, directionLumiere2);
    lumiereDirectionnelle2.setInfluencingBounds(bounds);
    arbreContenus.addChild(lumiereDirectionnelle2);
  }

  private void usage() {
    System.out.println(
    "Usage: java ChangePointDeVue nomFichier.obj");
    System.exit(0);
  }

  public ChangePointDeVue(String args[]) {
    String nomFichier = null;
    if (args.length == 0) { 
      usage();
    } else {
      nomFichier = args[0];
    }

    if (nomFichier == null) { usage(); }
    Canvas3D canvas = new
      Canvas3D(SimpleUniverse.getPreferredConfiguration());
    univers = new SimpleUniverse (canvas);
    BranchGroup arbreContenus = construitScene(nomFichier);
    univers.addBranchGraph (arbreContenus);
    univers.getViewingPlatform().setNominalViewingTransform();
    setTitle("ChangePointDeVue");
    setSize(300, 300);
    Container contentPane = getContentPane();
    contentPane.setLayout(new BorderLayout());
    contentPane.add(BorderLayout.CENTER, canvas);
    setVisible(true);
  }

  public static void main(String[] args) {
    new ChangePointDeVue(args);
  }
}